
var oXmlHttp = null;
var iInterval = 1000;
var iLastCommentId = -1;
var divNotification = null;
var blnRequestsEnabled = true;

function checkComments() {

    if (blnRequestsEnabled) {
        try {
            if (!oXmlHttp) {
                oXmlHttp = zXmlHttp.createRequest();
            } else if (oXmlHttp.readyState != 0) {
                oXmlHttp.abort();
            }    
            
            oXmlHttp.open("get", "CheckComments.php", true);
            oXmlHttp.onreadystatechange = function () {               
                
                if (oXmlHttp.readyState == 4) {
                    if (oXmlHttp.status == 200) {
        
                        var aData = oXmlHttp.responseText.split("||");
                        if (aData[0] != iLastCommentId) {                   
                            
                            if (iLastCommentId != -1) {                        
                                showNotification(aData[1], aData[2]);
                            }
                            
                            iLastCommentId = aData[0];
                        }
                        
                        setTimeout(checkComments, iInterval);             
                    } else {
                        throw new Error("Podczas wykonywania dania wystapi bd.");
                    }                        
                } 
            };    
        
            oXmlHttp.send(null); 
        } catch (oException) {
            blnRequestsEnabled = false;
        }
    } //End: if     
}

function showNotification(sName, sMessage) {
    if (!divNotification) {
        divNotification = document.createElement("div");
        divNotification.className = "notification";
        document.body.appendChild(divNotification);
    }
    
    divNotification.innerHTML = "<strong>Nowy komentarz</strong><br />" + sName 
              + " napisa: " + sMessage + "...<br /><a href=\"ViewComment.php?id=" 
              + iLastCommentId + "\">Zobacz</a>";
    divNotification.style.top = document.body.scrollTop + "px";
    divNotification.style.left = document.body.scrollLeft + "px";
    divNotification.style.display = "block";
    setTimeout(function () {
        divNotification.style.display = "none";
    }, 5000);
}

//Jeli Ajax, skonfiguruj procedury obsugi zdarze i rozpocznij pobieraniewindow.onload = function () {
    if (zXmlHttp.isSupported()) {
        checkComments();              
    }
};